' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data
Imports System.Data.SqlClient

''' <summary>
''' Klasa FaqDB jest uywana do przesyania pozycji Faq (zarwno pojedynczych egzemplarzy jak i list) do i z bazy danych.
''' </summary>
Public Class FaqDB

  ''' <summary>
  ''' Ukryj konstruktor aby unikn tworzenia egzemplarzy klasy FaqDB.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Zwraca list pozycji FAQ z bazy danych jako DataSet w oparciu o wyszukiwanie boolowskie.
  ''' </summary>
  ''' <param name="searchTerm">Termin do wyszukania. Moe zawiera operatory AND i OR wpywajce na otrzymane wyniki.</param>
  ''' <returns>DataSet z danymi pozycjami FAQ.</returns>
  Public Shared Function GetFaqList(ByVal searchTerm As String) As DataSet
    Dim myDataSet As DataSet = New DataSet()
    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand("sprocFaqSelectListBySearchTerm", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        Dim whereClause As String = BuildWhereClause(searchTerm)

        myCommand.Parameters.AddWithValue("@whereClause", whereClause)

        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand
        myDataAdapter.Fill(myDataSet)
        myConnection.Close()
        Return myDataSet
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function

  ''' <summary>
  ''' Zwraca list wszystkich pozycji Faq w bazie danych. Metoda uywana w sekcji adninistracyjnej witryny.
  ''' </summary>
  ''' <returns>DataSet z danymi pozycjami FAQ.</returns>
  Public Shared Function GetFaqList() As DataSet
    Dim myDataSet As DataSet = New DataSet()

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand("sprocFaqSelectList", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand
        myDataAdapter.Fill(myDataSet)
        myConnection.Close()
        Return myDataSet
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function

  ''' <summary>
  ''' Pobiera Faq z bazy danych.
  ''' </summary>
  Public Shared Function [Get](ByVal id As Integer) As Faq
    Dim theFaq As Faq = Nothing
    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

        Dim myCommand As SqlCommand = New SqlCommand("sprocFaqSelectSingleItem", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        myCommand.Parameters.AddWithValue("@id", id)

        myConnection.Open()
        Using myReader As SqlDataReader = myCommand.ExecuteReader(CommandBehavior.CloseConnection)
          If myReader.Read() Then
            theFaq = New Faq(myReader.GetInt32(myReader.GetOrdinal("Id")))
            theFaq.QuestionShort = myReader.GetString(myReader.GetOrdinal("QuestionShort"))
            theFaq.QuestionLong = myReader.GetString(myReader.GetOrdinal("QuestionLong"))
            theFaq.Answer = myReader.GetString(myReader.GetOrdinal("Answer"))
          End If
          myReader.Close()
        End Using
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
    Return theFaq
  End Function

  ''' <summary>
  ''' Zapisuje Faq w bazie danych.
  ''' </summary>
  Public Shared Sub Save(ByVal theFaq As Faq)
    Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

      Dim myCommand As SqlCommand = New SqlCommand("sprocFaqInsertUpdateSingleItem", myConnection)
      myCommand.CommandType = CommandType.StoredProcedure

      If theFaq.Id > 0 Then
        myCommand.Parameters.AddWithValue("@id", theFaq.Id)
      Else
        myCommand.Parameters.AddWithValue("@id", DBNull.Value)
      End If
      myCommand.Parameters.AddWithValue("@questionShort", theFaq.QuestionShort)
      myCommand.Parameters.AddWithValue("@questionLong", theFaq.QuestionLong)
      myCommand.Parameters.AddWithValue("@answer", theFaq.Answer)

      myConnection.Open()
      myCommand.ExecuteNonQuery()
      myConnection.Close()
    End Using
  End Sub

  ''' <summary>
  ''' Usuwa Faq z bazy danych.
  ''' </summary>
  Public Shared Sub Delete(ByVal id As Integer)
    Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

      Dim myCommand As SqlCommand = New SqlCommand("sprocFaqDeleteSingleItem", myConnection)
      myCommand.CommandType = CommandType.StoredProcedure

      myCommand.Parameters.AddWithValue("@id", id)

      myConnection.Open()
      myCommand.ExecuteNonQuery()
      myConnection.Close()
    End Using
  End Sub

  ''' <summary>
  ''' Tworzy klauzul WHERE uywan w proceurze skadowanej sprocFaqSelectListBySearchTerm.
  ''' </summary>
  ''' <param name="searchTerm">Termin do wyszukania. Moe zawiera operatory AND i OR wpywajce na otrzymane wyniki.</param>
  ''' <returns>acuch z klauzul WHERE (bez samego sowa kluczowego WHERE).</returns>
  ''' <remarks>Zamienia potencjalnie niebezpieczne znaki na pusty acuch tekstowy, tak wic ostateczny warunek WHERE nie zawsze musi by taki, jak si spodziewae.</remarks>
  Private Shared Function BuildWhereClause(ByVal searchTerm As String) As String
    Dim simpleSearch As Boolean = True
    Dim whereClause As String = String.Empty

    searchTerm = searchTerm.Trim()
    searchTerm = searchTerm.Replace("'", "''")
    searchTerm = searchTerm.Replace("""", "")
    searchTerm = searchTerm.Replace("%", "")
    searchTerm = searchTerm.Replace("--", "")
    searchTerm = searchTerm.Replace(";", "")
    searchTerm = searchTerm.Replace("(", "")
    searchTerm = searchTerm.Replace(")", "")
    searchTerm = searchTerm.Replace("_", "")

    ' Zmie acuch tak, by zwyke spacje byy traktowane jako operatory AND
    Dim testReplace As String = ""
    testReplace = searchTerm.ToUpper().Replace(" AND ", "")
    If testReplace <> searchTerm.ToUpper() Then
      ' acuch zawiera AND
      simpleSearch = False
    End If

    testReplace = searchTerm.ToUpper().Replace(" OR ", "")
    If testReplace <> searchTerm.ToUpper() Then
      '  acuch zawiera OR
      simpleSearch = False
    End If

    If simpleSearch = True Then
      searchTerm = searchTerm.Replace(" ", " AND ")
    End If

    Dim myAndSplits() As String = Regex.Split(searchTerm, " and ", RegexOptions.IgnoreCase)

    For i As Integer = 0 To myAndSplits.Length - 1

      Dim myOrSplits() As String = Regex.Split(myAndSplits(i), " or ", RegexOptions.IgnoreCase)
      whereClause += "("
      For j As Integer = 0 To myOrSplits.Length - 1
        whereClause += "(F.QuestionShort LIKE '%" & myOrSplits(j) & "%' OR F.QuestionLong LIKE '%" & myOrSplits(j) & "%' OR F.Answer LIKE '%" & myOrSplits(j) & "%')"

        If (j + 1) < myOrSplits.Length Then
          whereClause += " OR "
        End If
      Next

      whereClause += ") "

      If (i + 1) < myAndSplits.Length Then

        whereClause += " AND "
      End If

    Next
    Return whereClause
  End Function
End Class
